﻿using System;
using System.Linq;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.MakeAppointment
{
    public class GetIntegrationSettingsStep : FilterBase<MakeAppointmentStateObject>
    {
        public override void Execute(MakeAppointmentStateObject state)
        {
            var errorString = string.Format(Strings.IntegrationSettingsErrorString, "{0}", "Make Appointment");

            using (var srv = new Xrm(state.OrganizationServiceProxy))
            {
                var fakeTypeString = Strings.MakeFakeResponseType;
                var fakeType = srv.mcs_integrationsettingSet.FirstOrDefault(i => i.mcs_name == fakeTypeString);
                state.VistaFakeResponseType = fakeType == null ? string.Empty : fakeType.mcs_value;

                var vistaAppointmentTypeString = Strings.ApptType;
                var apptType = srv.mcs_integrationsettingSet.FirstOrDefault(i => i.mcs_name == vistaAppointmentTypeString);
                if (apptType == null) throw new Exception(string.Format(errorString, vistaAppointmentTypeString));
                else state.VistaAppointmentType = apptType.mcs_value;

                var purposeString = Strings.ApptPurpose;
                var purpose = srv.mcs_integrationsettingSet.FirstOrDefault(i => i.mcs_name == purposeString);
                if (purpose == null) throw new Exception(string.Format(errorString, purposeString));
                state.VistaAppointmentPurpose = purpose.mcs_value;
            }
        }
    }
}
